#include "SSH.h"

namespace Upp {

#define LLOG(x)	 RLOG(x)

Scp& Scp::StartGet(Stream& out, const String& path, Gate<int64, int64> progress)
{
	ClearQueue(); // Disables channel initialization. (Scp does not use a generic channel.)

	AddJob() << [=, &out] {
		channel = libssh2_scp_recv2(ssh->GetSession(), path, &file_stat);
		if(channel) {
			LLOG("++ SCP: (Read) Channel obtained.");
			return false;
		}
		if(!WouldBlock()) Error();
		return true;
	};
	AddJob() << [=, &out] { return DataRead(0, out, file_stat.st_size, progress); };
	StartSendRecvEof();
	return *this;
}

Scp& Scp::StartPut(Stream& in, const String& path, long mode, Gate<int64, int64> progress)
{
	ClearQueue(); // Disables channel initialization. (Scp does not use a generic channel.)

	AddJob() << [=, &in] {
		channel = libssh2_scp_send64(ssh->GetSession(),	path, mode, in.GetSize(), 0, 0);
		if(channel) {
			LLOG("++ SCP: (Write) Channel obtained.");
			return false;
		}
		if(!WouldBlock()) Error();
		return true;
	};
	AddJob() << [=, &in] { return DataWrite(0, in, in.GetSize(), progress); };
	StartSendRecvEof();
	return *this;
}
}